function [hamming_coded_input_data, added_number_zeros_hamming] = hamming_coding(input_data,nr_parity_bits)

% WATCH THESE VIDEOS BEFORE READING: (only takes 5 minutes)
% https://www.youtube.com/watch?v=TYwrHiQ2-G4
% https://www.youtube.com/watch?v=osS9EaKNSI4

% The hamming code is repeated in periods with the following data length
data_period_length = 2^nr_parity_bits -1;
% We need to zeropad so that the number of periods is an integer
[input_data, added_number_zeros_hamming] = zero_padding(input_data, data_period_length - nr_parity_bits);
data_length = length(input_data);

% This is the number of periods (repetitions)
nr_periods = data_length/(data_period_length - nr_parity_bits);
% Preallocation for the hamming coded data
hamming_coded_input_data = zeros(1,data_length+nr_periods*nr_parity_bits);
% This is preallocation for the period that is currently being hamming coded
current_hamming_data_period = zeros(1,data_period_length);

% This is the actual data length in one period (without parity bits)
data_period_without_parity = data_period_length-nr_parity_bits;

% Counter for hamming coded data period
n = 0;

for k=1:data_period_without_parity:data_length
    
    % Pick out the data that will be hamming coded in one period
    current_data_period = input_data(k:k+data_period_without_parity-1);
    
    % l is determining where the parity bits are located
    l = 0;
    
    % m is the index of the current data bit in the period
    m = 1;
    
    % current parity bit considered
    ii = 0;
    
    % here we  parity bits to the current period
    
    for j=1:data_period_length
               
        
        % the parity bits are located every 2^l position
        if j == 2^l
        
        current_hamming_data_period(j) = 0;
        
        l=l+1;
        
        else
            
        % at all other locations we place data bits
            
        current_hamming_data_period(j) = current_data_period(m);
        
        m = m+1;
        
        end
        
    end
        
    % here we determine what each parity bit should be, 0 or 1
    
    while ii < nr_parity_bits
        
    % we sum up bits to determine the current parity bit   
    % initialized to zero
    current_parity_sum = 0;
    current_parity_position = 2^ii;    
    
    for g = 0:current_parity_position-1;
        
    % we sum up all the data differently for each parity bit
    % if parity bit position = 1, every alternate data bit is added
    % together, if parity bit position = 2, we sum 2 bits, leave 2 bits,
    % sum 2 bits and so on until the end of the period
    
    % we always start at the parity position
    current_parity_sum_tmp = sum(current_hamming_data_period(...
    current_parity_position+g:2^(ii+1):data_period_length));
    
    % this is the updated sum
    current_parity_sum = current_parity_sum + current_parity_sum_tmp;

    end
    % if the sum is even, parity = 0
        if mod(current_parity_sum,2) == 0
        
        current_parity = 0;
    
    % if the sum is odd, parity = 1
        else 
        
        current_parity = 1;
        
        end
        
    % we place the calculated parity bit at its position    
    current_hamming_data_period(current_parity_position) = current_parity;    
        
    % counter for the current parity bit is updated
    ii = ii+1;
       
    end 
    
    % we go on til the next hamming period
    hamming_coded_input_data(n*data_period_length+1:(n+1)*data_period_length) = current_hamming_data_period;   
    
    % counter for the hamming period is updated
    n = n+1;
    
end



end